DROP TABLE IF EXISTS products;
CREATE TABLE products (
  id INT PRIMARY KEY,             -- 商品ID（手動入力）
  name VARCHAR(100) NOT NULL,     -- 商品名
  category VARCHAR(50) NOT NULL,  -- カテゴリ（ドリンク・フード・デザート・軽食など）
  price INT NOT NULL,             -- 価格
  stock INT NOT NULL,             -- 在庫数
  reg_date DATE                   -- 登録日
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO products (id, name, category, price, stock, reg_date) VALUES
(1, 'ブレンドコーヒー', 'ドリンク', 450, 30, '2019-02-01'),
(2, 'アイスコーヒー', 'ドリンク', 500, 20, '2020-06-15'),
(3, 'カフェラテ', 'ドリンク', 550, 25, '2021-09-10'),
(4, 'コーヒーカップ', 'グッズ', 1200, 15, '2024-01-05'),
(5, 'クロワッサン', '軽食', 300, 15, '2023-03-05'),
(6, 'タンブラー', 'グッズ', 1500, 10, '2023-12-10'),
(7, 'チーズケーキ', 'デザート', 600, 8, '2020-10-30'),
(8, 'ショートケーキ', 'デザート', 650, 5, '2021-05-14'),
(9, 'モンブラン', 'デザート', 700, 6, '2023-11-22'),
(10, 'アップルパイ', 'デザート', 550, 9, '2019-08-18'),
(11, 'ステンレスボトル', 'グッズ', 2500, 12, '2024-02-01'),
(12, 'ホットサンド', '軽食', 700, 10, '2022-07-20'),
(13, 'エコバッグ', 'グッズ', 800, 0, '2023-11-25'),
(14, '紅茶', 'ドリンク', 400, 15, '2019-12-25')
;
DROP TABLE IF EXISTS `orders`;
CREATE TABLE IF NOT EXISTS `orders` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `order_date` date NOT NULL,
  `total_price` int(11) NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `orders` (`id`, `customer_id`, `order_date`, `total_price`, `status`) VALUES
(1, 1, '2025-04-13', 1200, '出荷済'),
(2, 2, '2025-06-29', 500, '出荷待ち'),
(3, 3, '2025-04-03', 2000, '出荷済'),
(4, 1, '2025-01-15', 750, 'キャンセル'),
(5, 4, '2025-04-17', 1800, '出荷済'),
(6, 2, '2025-03-13', 950, '出荷待ち'),
(7, 5, '2025-01-21', 1500, '出荷済'),
(8, 3, '2025-04-13', 2300, '出荷済'),
(9, 1, '2025-05-02', 800, 'キャンセル'),
(10, 4, '2025-03-16', 1250, '出荷待ち'),
(11, 2, '2025-03-29', 1750, '出荷済'),
(12, 5, '2025-04-27', 600, '出荷待ち'),
(13, 3, '2025-04-10', 1950, '出荷済'),
(14, 1, '2025-04-14', 500, '出荷済'),
(15, 4, '2025-06-01', 2500, '出荷待ち');
COMMIT;

DROP TABLE IF EXISTS `employees`;
CREATE TABLE IF NOT EXISTS `employees` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `department` varchar(50) NOT NULL,
  `salary` int(11) NOT NULL,
  `hire_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `employees` (`id`, `name`, `department`, `salary`, `hire_date`) VALUES
(1, '田中 太郎', '営業部', 500000, '2022-01-15'),
(2, '山田 花子', '人事部', 450000, '2023-06-20'),
(3, '佐藤 一郎', '開発部', 600000, '2021-11-10'),
(4, '鈴木 次郎', '営業部', 550000, '2020-08-01'),
(5, '高橋 美咲', 'マーケティング部', 470000, '2024-02-05'),
(6, '吉田 修', '開発部', 620000, '2025-01-15'),
(7, '川崎 翔', '営業部', 530000, '2024-12-01'),
(8, '宮本 忍', 'マーケティング部', 480000, '2025-02-20'),
(9, '井上 大輔', '営業部', 520000, '2019-07-15'),
(10, '渡辺 美咲', '人事部', 460000, '2021-10-20'),
(11, '藤田 涼', '開発部', 610000, '2020-03-18'),
(12, '坂本 直人', 'マーケティング部', 490000, '2023-09-10'),
(13, '石井 和夫', '開発部', 630000, '2022-05-25'),
(14, '中村 愛', '人事部', 455000, '2023-07-30'),
(15, '森本 真', '営業部', 540000, '2024-11-11');
COMMIT;

DROP TABLE IF EXISTS `customers`;
CREATE TABLE IF NOT EXISTS `customers` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `customers` (`id`, `name`, `email`, `created_at`) VALUES
(1, '佐藤 一郎', 'sato@example.com', '2024-01-05'),
(2, '田中 花子', 'tanaka@gmail.com', '2023-12-12'),
(3, '山本 健', 'yamamoto@yahoo.co.jp', '2022-07-23'),
(4, '斉藤 涼', 'saito@example.com', '2021-09-17'),
(5, '藤田 陽子', 'fujita@gmail.com', '2020-05-30'),
(6, '吉村 大輔', 'yoshimura@example.com', '2024-02-11'),
(7, '大橋 香', 'ohashi@gmail.com', '2024-10-05'),
(8, '村上 誠', 'murakami@yahoo.co.jp', '2023-11-20'),
(9, '長谷川 亮', 'hasegawa@example.com', '2022-06-25'),
(10, '本田 修', 'honda@gmail.com', '2021-04-18'),
(11, '内田 翔', 'uchida@yahoo.co.jp', '2020-03-12'),
(12, '上田 真央', 'ueda@example.com', '2019-12-03'),
(13, '今井 謙', 'imai@gmail.com', '2023-01-09'),
(14, '浜田 直樹', 'hamada@yahoo.co.jp', '2022-08-15'),
(15, '坂井 美紀', 'sakai@example.com', '2021-05-22');
COMMIT;
