DROP TABLE IF EXISTS products;
CREATE TABLE products (
  id INT PRIMARY KEY,             -- 商品ID（手動入力）
  name VARCHAR(100) NOT NULL,     -- 商品名
  category VARCHAR(50) NOT NULL,  -- カテゴリ（ドリンク・フード・デザート・軽食など）
  price INT NOT NULL,             -- 価格
  stock INT NOT NULL,             -- 在庫数
  reg_date DATE                   -- 登録日
);

INSERT INTO products (id, name, category, price, stock, reg_date) VALUES
(1, 'ブレンドコーヒー', 'ドリンク', 450, 30, '2019-02-01'),
(2, 'アイスコーヒー', 'ドリンク', 500, 20, '2020-06-15'),
(3, 'カフェラテ', 'ドリンク', 550, 25, '2021-09-10'),
(4, 'コーヒーカップ', 'グッズ', 1200, 15, '2024-01-05'),
(5, 'クロワッサン', '軽食', 300, 15, '2023-03-05'),
(6, 'タンブラー', 'グッズ', 1500, 10, '2023-12-10'),
(7, 'チーズケーキ', 'デザート', 600, 8, '2020-10-30'),
(8, 'ショートケーキ', 'デザート', 650, 5, '2021-05-14'),
(9, 'モンブラン', 'デザート', 700, 6, '2023-11-22'),
(10, 'アップルパイ', 'デザート', 550, 9, '2019-08-18'),
(11, 'ステンレスボトル', 'グッズ', 2500, 12, '2024-02-01'),
(12, 'ホットサンド', '軽食', 700, 10, '2022-07-20'),
(13, 'エコバッグ', 'グッズ', 800, 0, '2023-11-25'),
(14, '紅茶', 'ドリンク', 400, 15, '2019-12-25')
;
